/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonValidationTask
implements Task {
    private String json;
    private String schema;
    private Logger logger;

    public JsonValidationTask(Logger logger, @Input(value="json") String json, @Input(value="schema") String schema) {
        this.logger = logger;
        this.json = json;
        this.schema = schema;
    }

    public TaskExecutionResult execute() {
        try {
            JSONObject schemaJson = new JSONObject(new JSONTokener(this.schema));
            JSONObject document = new JSONObject(new JSONTokener(this.json));
            Schema createdSchema = SchemaLoader.load((JSONObject)schemaJson);
            createdSchema.validate((Object)document);
        }
        catch (ValidationException validationException) {
            validationException.getAllMessages().forEach(message -> this.logger.error(message));
            return TaskExecutionResult.ko();
        }
        catch (JSONException jsonException) {
            this.logger.error("Exception: " + jsonException.getMessage());
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }
}

