/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.time.Duration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

final class MicrometerTaskHelper {
    MicrometerTaskHelper() {
    }

    static MeterRegistry checkRegistry(MeterRegistry registry) {
        return Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    static Integer checkIntOrNull(String str) {
        return MicrometerTaskHelper.checkMapOrNull(str, Integer::parseInt);
    }

    static Long checkLongOrNull(String str) {
        return MicrometerTaskHelper.checkMapOrNull(str, Long::parseLong);
    }

    static Double checkDoubleOrNull(String str) {
        return MicrometerTaskHelper.checkMapOrNull(str, Double::parseDouble);
    }

    static java.time.Duration checkDurationOrNull(String str) {
        return MicrometerTaskHelper.checkMapOrNull(str, MicrometerTaskHelper::parseDuration);
    }

    static TimeUnit checkTimeUnit(String str) {
        return Optional.ofNullable(str).map(TimeUnit::valueOf).orElse(TimeUnit.SECONDS);
    }

    static <T, U> T checkMapOrNull(U nullable, Function<U, T> mapfunction) {
        return Optional.ofNullable(nullable).map(mapfunction).orElse(null);
    }

    static Map<String, Object> toOutputs(String key, Object value) {
        if (value != null) {
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            outputs.put(key, value);
            return outputs;
        }
        return Collections.emptyMap();
    }

    static double[] parsePercentilesList(String percentiles) {
        return MicrometerTaskHelper.splitStringList(percentiles).mapToDouble(Double::parseDouble).toArray();
    }

    static java.time.Duration[] parseSlaListToDurations(String sla) {
        return (java.time.Duration[])MicrometerTaskHelper.splitStringList(sla).map(MicrometerTaskHelper::parseDuration).toArray(java.time.Duration[]::new);
    }

    static long[] parseSlaListToLongs(String sla) {
        return MicrometerTaskHelper.splitStringList(sla).mapToLong(Long::parseLong).toArray();
    }

    static void logTimerState(Logger logger, Timer timer, TimeUnit timeunit) {
        logger.info("Timer current total time is " + timer.totalTime(timeunit) + " " + timeunit);
        logger.info("Timer current max time is " + timer.max(timeunit) + " " + timeunit);
        logger.info("Timer current mean time is " + timer.mean(timeunit) + " " + timeunit);
        logger.info("Timer current count is " + timer.count());
    }

    private static java.time.Duration parseDuration(String duration) {
        return java.time.Duration.of(Duration.parse((String)duration).toMilliseconds(), ChronoUnit.MILLIS);
    }

    private static Stream<String> splitStringList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim);
    }
}

