/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.function;

import com.chutneytesting.task.spi.SpelFunction;
import java.util.Random;
import java.util.SortedSet;
import org.springframework.util.SocketUtils;

public class SocketFunctions {
    @SpelFunction
    public static int tcpPort() {
        return SocketUtils.findAvailableTcpPort();
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPorts(int num) {
        return SocketUtils.findAvailableTcpPorts((int)num);
    }

    @SpelFunction
    public static int tcpPortMin(int minPort) {
        return SocketUtils.findAvailableTcpPort((int)minPort);
    }

    @SpelFunction
    public static int tcpPortMinMax(int minPort, int maxPort) {
        return SocketUtils.findAvailableTcpPort((int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPortsMinMax(int num, int minPort, int maxPort) {
        return SocketUtils.findAvailableTcpPorts((int)num, (int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static int tcpPortRandomRange(int range) {
        Integer[] httpPortRange = SocketFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableTcpPort((int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static SortedSet<Integer> tcpPortsRandomRange(int num, int range) {
        Integer[] httpPortRange = SocketFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableTcpPorts((int)num, (int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static int udpPort() {
        return SocketUtils.findAvailableUdpPort();
    }

    @SpelFunction
    public static SortedSet<Integer> udpPorts(int num) {
        return SocketUtils.findAvailableUdpPorts((int)num);
    }

    @SpelFunction
    public static int udpPortMin(int minPort) {
        return SocketUtils.findAvailableUdpPort((int)minPort);
    }

    @SpelFunction
    public static int udpPortMinMax(int minPort, int maxPort) {
        return SocketUtils.findAvailableUdpPort((int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static SortedSet<Integer> udpPortsMinMax(int num, int minPort, int maxPort) {
        return SocketUtils.findAvailableUdpPorts((int)num, (int)minPort, (int)maxPort);
    }

    @SpelFunction
    public static int udpPortRandomRange(int range) {
        Integer[] httpPortRange = SocketFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableUdpPort((int)httpPortRange[0], (int)httpPortRange[1]);
    }

    @SpelFunction
    public static SortedSet<Integer> udpPortsRandomRange(int num, int range) {
        Integer[] httpPortRange = SocketFunctions.getRandomPortRange(range);
        return SocketUtils.findAvailableUdpPorts((int)num, (int)httpPortRange[0], (int)httpPortRange[1]);
    }

    private static Integer[] getRandomPortRange(int maxRangesNumber) {
        int range = 64511 / maxRangesNumber;
        int rangeMin = 1024 + new Random().nextInt(maxRangesNumber) * range;
        return new Integer[]{rangeMin, rangeMin + range};
    }
}

