/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp.consumer;

import com.chutneytesting.task.amqp.utils.AmqpUtils;
import com.chutneytesting.task.amqp.utils.JsonPathEvaluator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueingConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueingConsumer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final long maxAwait;
    private final Channel channel;
    private final String queueName;
    private final String selector;
    private final boolean ackIfMatch;
    private final CountDownLatch messageCounter;
    private final Result result;

    public QueueingConsumer(Channel channel, String queueName, int nbMessages, String selector, long maxAwait, boolean ackIfMatch) {
        this.selector = selector;
        this.maxAwait = maxAwait;
        this.channel = channel;
        this.queueName = queueName;
        this.ackIfMatch = ackIfMatch;
        this.result = new Result();
        this.messageCounter = new CountDownLatch(nbMessages);
    }

    public Result consume() throws IOException, InterruptedException {
        this.channel.basicConsume(this.queueName, this::deliveryCallback, this::cancelCallback);
        this.messageCounter.await(this.maxAwait, TimeUnit.MILLISECONDS);
        return this.result;
    }

    private void deliveryCallback(String consumerTag, Delivery delivery) {
        this.handleDelivery(delivery);
    }

    private void handleDelivery(Delivery delivery) {
        if (this.messageCounter.getCount() <= 0L) {
            return;
        }
        Map<String, Object> headerz = AmqpUtils.convertMapLongStringToString(delivery.getProperties().getHeaders());
        HashMap<String, Object> message = new HashMap<String, Object>();
        Object payload = this.extractPayload(delivery);
        message.put("headers", headerz);
        message.put("payload", payload);
        if (StringUtils.isBlank((CharSequence)this.selector)) {
            this.addMessageToResultAndCountDown(message);
        } else {
            try {
                String messageAsString = OBJECT_MAPPER.writeValueAsString(message);
                if (JsonPathEvaluator.evaluate(messageAsString, this.selector)) {
                    this.addMessageToResultAndCountDown(message);
                    this.acknowledgeMessage(delivery);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Received a message, however cannot read process it as json, Ignoring message selection.", (Throwable)e);
            }
        }
    }

    private void acknowledgeMessage(Delivery delivery) throws IOException {
        if (this.ackIfMatch) {
            this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
        }
    }

    private void addMessageToResultAndCountDown(Map<String, Object> message) {
        this.result.handleMessage(message);
        this.messageCounter.countDown();
    }

    private Object extractPayload(Delivery delivery) {
        Object payload;
        try {
            payload = OBJECT_MAPPER.readValue(new String(delivery.getBody()), Map.class);
        }
        catch (IOException e) {
            LOGGER.warn("Received a message, however cannot read it as Json fallback as String.", (Throwable)e);
            payload = new String(delivery.getBody());
        }
        return payload;
    }

    private void cancelCallback(String consumerTag) {
    }

    public static class Result {
        public final List<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
        public final List<Object> payloads = new ArrayList<Object>();
        public final List<Map<String, Object>> headers = new ArrayList<Map<String, Object>>();

        private void handleMessage(Map<String, Object> message) {
            this.messages.add(message);
            this.headers.add((Map)message.get("headers"));
            this.payloads.add(message.get("payload"));
        }
    }
}

