/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class AmqpCreateBoundTemporaryQueueTask
implements Task {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String exchangeName;
    private final String routingKey;
    private final String queueName;
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final ConnectionFactory connectionFactory;

    public AmqpCreateBoundTemporaryQueueTask(Target target, @Input(value="exchange-name") String exchangeName, @Input(value="routing-key") String routingKey, @Input(value="queue-name") String queueName, Logger logger, FinallyActionRegistry finallyActionRegistry) {
        this.target = target;
        this.connectionFactory = this.connectionFactoryFactory.create(target);
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.queueName = queueName;
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactory.newConnection();){
            TaskExecutionResult taskExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    this.createQueue(this.queueName, channel);
                    this.bindQueue(channel, this.queueName);
                    taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("queueName", this.queueName));
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private void bindQueue(Channel channel, String queueName) throws IOException {
        String routingKey = Optional.ofNullable(this.routingKey).orElse(queueName);
        channel.queueBind(queueName, this.exchangeName, routingKey);
        this.logger.info("Created AMQP binding " + this.exchangeName + " (with " + this.routingKey + ") -> " + queueName);
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-unbind-queue").withTarget(this.target).withInput("queue-name", (Object)queueName).withInput("exchange-name", (Object)this.exchangeName).withInput("routing-key", (Object)routingKey).build());
        this.logger.info("Registered unbinding finally action");
    }

    private void createQueue(String queueName, Channel channel) throws IOException {
        channel.queueDeclare(queueName, true, false, false, null);
        this.logger.info("Created AMQP Queue with name: " + queueName);
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-delete-queue").withTarget(this.target).withInput("queue-name", (Object)queueName).build());
    }
}

