/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class AmqpCleanQueuesTask
implements Task {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final ConnectionFactory connectionFactory;
    private final List<String> queueNames;
    private final Logger logger;

    public AmqpCleanQueuesTask(Target target, @Input(value="queue-names") List<String> queueNames, Logger logger) {
        this.connectionFactory = this.connectionFactoryFactory.create(target);
        this.queueNames = queueNames;
        this.logger = logger;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactory.newConnection();){
            TaskExecutionResult taskExecutionResult;
            block15: {
                Channel channel = connection.createChannel();
                try {
                    for (String queueName : this.queueNames) {
                        AMQP.Queue.PurgeOk purgeOk = channel.queuePurge(queueName);
                        this.logger.info("Purge queue " + queueName + ". " + purgeOk.getMessageCount() + " messages deleted");
                    }
                    taskExecutionResult = TaskExecutionResult.ok();
                    if (channel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

