/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh.sshj;

import com.chutneytesting.task.ssh.sshj.Command;
import com.chutneytesting.task.ssh.sshj.CommandResult;
import com.chutneytesting.task.ssh.sshj.Connection;
import com.chutneytesting.task.ssh.sshj.SshClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.springframework.util.StringUtils;

public class SshJClient
implements SshClient {
    private final Connection connection;
    private final boolean shell;

    public SshJClient(Connection connection) {
        this(connection, false);
    }

    public SshJClient(Connection connection, boolean shell) {
        this.connection = connection;
        this.shell = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(Command command) throws IOException {
        SSHClient sshClient = new SSHClient();
        this.connect(sshClient, this.connection);
        try {
            this.authenticate(sshClient, this.connection);
            CommandResult commandResult = this.executeCommand(sshClient, command);
            return commandResult;
        }
        finally {
            sshClient.disconnect();
        }
    }

    private void connect(SSHClient client, Connection connection) throws IOException {
        client.addHostKeyVerifier((a, b, c) -> true);
        client.connect(connection.serverHost, connection.serverPort);
    }

    private void authenticate(SSHClient client, Connection connection) throws IOException {
        if (StringUtils.isEmpty((Object)connection.privateKey)) {
            this.loginWithPassword(client, connection.username, connection.password);
        } else {
            this.loginWithPrivateKey(client, connection.username, connection.privateKey);
        }
    }

    private void loginWithPassword(SSHClient client, String username, String password) throws UserAuthException, TransportException {
        client.authPassword(username, password);
    }

    private void loginWithPrivateKey(SSHClient client, String username, String privateKey) throws IOException {
        KeyProvider keyProvider = client.loadKeys(privateKey);
        client.authPublickey(username, new KeyProvider[]{keyProvider});
    }

    private CommandResult executeCommand(SSHClient sshClient, Command command) throws IOException {
        try (Session session = sshClient.startSession();){
            if (this.shell) {
                CommandResult commandResult = this.shellCommand(command, session);
                return commandResult;
            }
            CommandResult commandResult = this.execCommand(command, session);
            return commandResult;
        }
    }

    private CommandResult shellCommand(Command command, Session session) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        session.allocateDefaultPTY();
        Session.Shell shell = session.startShell();
        new StreamCopier(shell.getInputStream(), (OutputStream)out, LoggerFactory.DEFAULT).bufSize(shell.getLocalMaxPacketSize()).spawn("out");
        new StreamCopier(shell.getErrorStream(), (OutputStream)err, LoggerFactory.DEFAULT).bufSize(shell.getLocalMaxPacketSize()).spawn("err");
        OutputStream shellOut = shell.getOutputStream();
        shellOut.write(command.command.getBytes());
        shellOut.flush();
        while (shell.getInputStream().available() > 0 && shell.getErrorStream().available() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return new CommandResult(command, err.size() > 0 ? -1 : 0, out.toString(), err.toString());
    }

    /*
     * Exception decompiling
     */
    private CommandResult execCommand(Command command, Session session) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        return IOUtils.readFully((InputStream)inputStream).toString().replaceAll("\r", "");
    }
}

