/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.kafka;

import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.kafka.test.EmbeddedKafkaBroker;

public class KafkaBrokerStartTask
implements Task {
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final int port;
    private final List<String> topics;
    private final Map<String, String> properties;

    public KafkaBrokerStartTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="port") String port, @Input(value="topics") List<String> topics, @Input(value="properties") Map<String, String> properties) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.port = Optional.ofNullable(port).map(Integer::parseInt).orElse(-1);
        this.topics = Optional.ofNullable(topics).orElse(Collections.emptyList());
        this.properties = Optional.ofNullable(properties).orElse(Collections.emptyMap());
    }

    public TaskExecutionResult execute() {
        try {
            EmbeddedKafkaBroker broker = new EmbeddedKafkaBroker(1, true, this.topics.toArray(new String[0]));
            this.configure(broker);
            this.logger.info("Try to start kafka broker");
            broker.afterPropertiesSet();
            this.createQuitFinallyAction(broker);
            return TaskExecutionResult.ok(this.toOutputs(broker));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private void configure(EmbeddedKafkaBroker broker) {
        if (this.port > 0) {
            broker.kafkaPorts(new int[]{this.port});
        }
        if (!this.properties.isEmpty()) {
            broker.brokerProperties(this.properties);
        }
    }

    private Map<String, Object> toOutputs(EmbeddedKafkaBroker broker) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("kafkaBroker", broker);
        return outputs;
    }

    private void createQuitFinallyAction(EmbeddedKafkaBroker broker) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"kafka-broker-stop").withInput("broker", (Object)broker).build());
        this.logger.info("KafkaBrokerStop finally action registered");
    }
}

