/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.jms.JmsConnectionFactory;
import com.chutneytesting.task.jms.UncheckedJmsException;
import com.chutneytesting.task.jms.consumer.Consumer;
import com.chutneytesting.task.jms.consumer.JmsListenerParameters;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class JmsCleanQueueTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final JmsListenerParameters listenerJmsParameters;
    private JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();

    public JmsCleanQueueTask(Target target, Logger logger, @Input(value="listenerJmsParameters") JmsListenerParameters listenerJmsParameters) {
        this.target = target;
        this.logger = logger;
        this.listenerJmsParameters = listenerJmsParameters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<Consumer> consumer = this.jmsConnectionFactory.createConsumer(this.target, this.listenerJmsParameters);){
            Optional<Message> message;
            int removedMessages = 0;
            while ((message = ((Consumer)consumer.getResource()).getMessage()).isPresent()) {
                this.displayMessageContent(this.logger, message.get());
                ++removedMessages;
            }
            this.logger.info("Removed " + removedMessages + " messages");
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok();
            return taskExecutionResult;
        }
        catch (UncheckedJmsException | JMSException e) {
            this.logger.error(e);
            return TaskExecutionResult.ko();
        }
    }

    private void displayMessageContent(Logger logger, Message message) throws JMSException {
        Map<String, String> properties = this.propertiesToMap(message);
        String body = message instanceof TextMessage ? ((TextMessage)message).getText() : "";
        logger.info("Removed: " + properties + " " + body);
    }

    private Map<String, String> propertiesToMap(Message message) throws JMSException {
        Enumeration propertyNames = message.getPropertyNames();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            properties.put(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
        }
        return properties;
    }
}

