/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.context;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ContextPutTask
implements Task {
    private final Logger logger;
    private final Map<String, Object> entries;

    public ContextPutTask(Logger logger, @Input(value="entries") Map<String, Object> entries) {
        this.logger = logger;
        this.entries = entries;
        this.assertExecutionIsPossible();
    }

    public TaskExecutionResult execute() {
        this.entries.forEach((key, value) -> this.logger.info("Adding to context " + key + " = " + this.prettyLog(value) + " " + this.logClassType(value)));
        return TaskExecutionResult.ok(this.entries);
    }

    private void assertExecutionIsPossible() {
        if (this.entries == null) {
            throw new IllegalArgumentException("Entries to put in context not found.");
        }
        if (this.entries.isEmpty()) {
            this.logger.info("Nothing to put in context");
        }
    }

    private String prettyLog(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        if (value instanceof List) {
            return Arrays.toString(((List)value).toArray());
        }
        if (value instanceof Map) {
            return Arrays.toString(((Map)value).entrySet().toArray());
        }
        return ToStringBuilder.reflectionToString((Object)value, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }

    private String logClassType(Object value) {
        return value != null ? "(" + value.getClass().getSimpleName() + ")" : "";
    }
}

