/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.ssh.sshj.CommandResult;
import com.chutneytesting.task.ssh.sshj.Commands;
import com.chutneytesting.task.ssh.sshj.Connection;
import com.chutneytesting.task.ssh.sshj.SshJClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SshClientTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final Commands commands;
    private CHANNEL channel;

    public SshClientTask(Target target, Logger logger, @Input(value="commands") List<Object> commands, @Input(value="channel") String channel) {
        this.target = target;
        this.logger = logger;
        this.commands = Commands.from(commands);
        this.channel = Optional.ofNullable(channel).map(CHANNEL::from).orElse(CHANNEL.COMMAND);
    }

    public TaskExecutionResult execute() {
        try {
            Connection connection = Connection.from(this.target);
            SshJClient sshClient = new SshJClient(connection, CHANNEL.SHELL.equals((Object)this.channel));
            List<CommandResult> commandResults = this.commands.executeWith(sshClient);
            HashMap<String, List<CommandResult>> taskResult = new HashMap<String, List<CommandResult>>();
            taskResult.put("results", commandResults);
            return TaskExecutionResult.ok(taskResult);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private static enum CHANNEL {
        COMMAND,
        SHELL;


        public static CHANNEL from(String channel) {
            for (CHANNEL value : CHANNEL.values()) {
                if (!value.name().equalsIgnoreCase(channel)) continue;
                return value;
            }
            return COMMAND;
        }
    }
}

