/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.mongo;

import com.chutneytesting.task.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.task.mongo.MongoDatabaseFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collections;

public class MongoListTask
implements Task {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;

    public MongoListTask(Target target, Logger logger) {
        this.target = target;
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);){
            MongoIterable collectionNames = ((MongoDatabase)database.getResource()).listCollectionNames();
            ArrayList collectionNameList = new ArrayList();
            collectionNames.iterator().forEachRemaining(collectionNameList::add);
            this.logger.info("Found " + collectionNameList.size() + " collection(s)");
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok(Collections.singletonMap("collectionNames", collectionNameList));
            return taskExecutionResult;
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

