/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http.domain;

import com.chutneytesting.task.http.domain.HttpClient;
import com.chutneytesting.task.spi.injectable.SecurityInfo;
import com.chutneytesting.task.spi.injectable.Target;
import java.io.IOException;
import java.net.ProxySelector;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientFactory {
    public HttpClient create(Target target, ParameterizedTypeReference<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(target.security(), timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.url() + resource, httpMethod, input, responseType, new Object[0]);
    }

    public HttpClient create(Target target, Class<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(target.security(), timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.url() + resource, httpMethod, input, responseType, new Object[0]);
    }

    private static RestTemplate buildRestTemplate(SecurityInfo securityInfo, int timeout) {
        SSLContext sslContext = HttpClientFactory.buildSslContext(securityInfo);
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        HttpClientBuilder httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        Optional<String> proxyHost = Optional.ofNullable(System.getProperty("http.proxyHost"));
        proxyHost.ifPresent(host -> httpClient.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())));
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((org.apache.http.client.HttpClient)httpClient.build());
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpClientFactory.configureBasicAuth(securityInfo, restTemplate);
        HttpClientFactory.removeErrorHandler(restTemplate);
        return restTemplate;
    }

    private static SSLContext buildSslContext(SecurityInfo securityInfo) {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            HttpClientFactory.configureTrustStore(securityInfo, sslContextBuilder);
            HttpClientFactory.configureKeyStore(securityInfo, sslContextBuilder);
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void removeErrorHandler(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    private static void configureBasicAuth(SecurityInfo securityInfo, RestTemplate restTemplate) {
        if (securityInfo.credential().isPresent()) {
            restTemplate.getInterceptors().add(new BasicAuthorizationInterceptor(((SecurityInfo.Credential)securityInfo.credential().get()).username(), ((SecurityInfo.Credential)securityInfo.credential().get()).password()));
        }
    }

    private static void configureKeyStore(SecurityInfo securityInfo, SSLContextBuilder sslContextBuilder) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (securityInfo.keyStore().isPresent()) {
            KeyStore keyMaterial = KeyStore.getInstance(KeyStore.getDefaultType());
            keyMaterial.load(Paths.get((String)securityInfo.keyStore().get(), new String[0]).toUri().toURL().openStream(), securityInfo.keyStorePassword().orElse("").toCharArray());
            sslContextBuilder.loadKeyMaterial(keyMaterial, securityInfo.keyStorePassword().orElse("").toCharArray());
        }
    }

    private static void configureTrustStore(SecurityInfo securityInfo, SSLContextBuilder sslContextBuilder) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (securityInfo.trustStore().isPresent()) {
            KeyStore trustMaterial = KeyStore.getInstance(KeyStore.getDefaultType());
            trustMaterial.load(Paths.get((String)securityInfo.trustStore().get(), new String[0]).toUri().toURL().openStream(), securityInfo.trustStorePassword().orElse("").toCharArray());
            sslContextBuilder.loadTrustMaterial(trustMaterial, (TrustStrategy)new TrustSelfSignedStrategy());
        } else {
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
        }
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) {
        }
    }
}

