/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion.compareTask;

import com.chutneytesting.task.assertion.compareTask.CompareExecutor;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.function.BiFunction;

public abstract class AbstractCompareNumberTask
implements CompareExecutor {
    protected abstract BiFunction<Double, Double, Boolean> compareFunction();

    protected abstract String getFunctionName();

    protected abstract String getOppositeFunctionName();

    @Override
    public TaskExecutionResult compare(Logger logger, String actual, String expected) {
        Double actualD = this.parse(logger, actual);
        Double expectedD = this.parse(logger, expected);
        Boolean apply = this.compareFunction().apply(actualD, expectedD);
        if (apply.booleanValue()) {
            logger.info("[" + actual + "] " + this.getFunctionName() + " [" + expected + "]");
            return TaskExecutionResult.ok();
        }
        logger.error("[" + actual + "] " + this.getOppositeFunctionName() + " [" + expected + "]");
        return TaskExecutionResult.ko();
    }

    private Double parse(Logger logger, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.error("[" + value + "] is Not Numeric");
            return Double.NaN;
        }
    }
}

