/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumFindBehavior;
import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumSwitchToTask
extends SeleniumTask
implements SeleniumFindBehavior {
    private static final String SELENIUM_OUTPUTS_KEY = "outputSwitchTo";
    private final String selector;
    private final String by;
    private final Integer wait;
    private final String switchType;

    public SeleniumSwitchToTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="switchType") String switchType) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
        this.switchType = switchType;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        switch (Optional.ofNullable(this.switchType).orElse("")) {
            case "Frame": {
                if (!webElement.isPresent()) break;
                this.webDriver.switchTo().frame((WebElement)webElement.get());
                this.logger.info("Switch to frame");
                break;
            }
            case "Window": {
                if (!webElement.isPresent()) {
                    if (this.selector != null && this.by == null) {
                        this.webDriver.switchTo().window(this.selector);
                        this.logger.info("Switch to window");
                        return TaskExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)this.webDriver.getWindowHandle());
                    }
                    this.webDriver.switchTo().defaultContent();
                    this.logger.info("Switch to default content");
                    break;
                }
                return TaskExecutionResult.ko();
            }
            case "Popup": {
                if (!webElement.isPresent()) {
                    Set windowHandlers = this.webDriver.getWindowHandles();
                    String parentWindowHandler = this.webDriver.getWindowHandle();
                    String popupHandler = windowHandlers.stream().filter(h -> !parentWindowHandler.equals(h)).findFirst().get();
                    this.webDriver.switchTo().window(popupHandler);
                    this.logger.info("Switch to popup");
                    return TaskExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)popupHandler);
                }
                return TaskExecutionResult.ko();
            }
            case "AlertOk": {
                try {
                    this.webDriver.switchTo().alert().accept();
                    this.logger.info("Switch to alert and click on the OK button");
                    return TaskExecutionResult.ok();
                }
                catch (Exception e) {
                    return TaskExecutionResult.ko();
                }
            }
            case "AlertCancel": {
                try {
                    this.webDriver.switchTo().alert().dismiss();
                    this.logger.info("Switch to alert and click on the Cancel button");
                    return TaskExecutionResult.ok();
                }
                catch (Exception e) {
                    return TaskExecutionResult.ko();
                }
            }
            default: {
                this.webDriver.switchTo().defaultContent();
                this.logger.info("Switch to default content");
            }
        }
        return TaskExecutionResult.ok();
    }
}

