/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms.consumer;

import com.chutneytesting.task.jms.consumer.Consumer;
import com.chutneytesting.task.jms.consumer.JmsListenerParameters;
import com.chutneytesting.task.jms.consumer.SelectedMessageConsumer;
import com.chutneytesting.task.jms.consumer.SimpleMessageConsumer;
import com.chutneytesting.task.jms.consumer.bodySelector.BodySelector;
import com.chutneytesting.task.jms.consumer.bodySelector.BodySelectorFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;

public class ConsumerFactory {
    private final BodySelectorFactory bodySelectorFactory = new BodySelectorFactory();
    private final JmsListenerParameters arguments;

    public ConsumerFactory(JmsListenerParameters arguments) {
        this.arguments = arguments;
    }

    public Consumer build(Session session, Destination destination) throws JMSException {
        Consumer consumer;
        if (this.arguments.bodySelector == null) {
            MessageConsumer messageConsumer = session.createConsumer(destination, this.arguments.selector);
            consumer = new SimpleMessageConsumer(messageConsumer, this.arguments.timeout);
        } else {
            QueueBrowser browser = session.createBrowser((Queue)destination, this.arguments.selector);
            BodySelector bodySelector = this.bodySelectorFactory.build(this.arguments.bodySelector);
            consumer = new SelectedMessageConsumer(browser, bodySelector, this.arguments.browserMaxDepth);
        }
        return consumer;
    }
}

