/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.jms.JmsConnectionFactory;
import com.chutneytesting.task.jms.UncheckedJmsException;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.tools.CloseableResource;
import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;

public class JmsSenderTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final String destination;
    private final String body;
    private final Map<String, String> headers;
    private JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();

    public JmsSenderTask(Target target, Logger logger, @Input(value="destination") String destination, @Input(value="body") String body, @Input(value="headers") Map<String, String> headers) {
        this.target = target;
        this.logger = logger;
        this.destination = destination;
        this.body = body;
        this.headers = headers != null ? headers : Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (CloseableResource<JmsConnectionFactory.MessageSender> producer = this.jmsConnectionFactory.getMessageProducer(this.target, this.destination);){
            ((JmsConnectionFactory.MessageSender)producer.getResource()).send(this.body, this.headers);
            this.logger.info("Successfully sent message on " + this.destination + " to " + this.target.name() + " (" + this.target.url() + ")");
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok();
            return taskExecutionResult;
        }
        catch (UncheckedJmsException | JMSException e) {
            this.logger.error(e);
            return TaskExecutionResult.ko();
        }
    }
}

