/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http;

import com.chutneytesting.task.function.XmlFunction;
import com.chutneytesting.task.http.domain.HttpClient;
import com.chutneytesting.task.http.domain.HttpClientFactory;
import com.chutneytesting.task.http.domain.HttpTask;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class HttpSoapTask
implements Task {
    private static final long DEFAULT_TIMEOUT = 2000L;
    private final Target target;
    private final Logger logger;
    private final String uri;
    private final String username;
    private final String password;
    private final Object body;
    private final int timeout;

    public HttpSoapTask(Target target, Logger logger, @Input(value="uri") String uri, @Input(value="body") String body, @Input(value="username") String username, @Input(value="password") String password, @Input(value="timeout") String timeout) {
        this.target = target;
        this.logger = logger;
        this.uri = uri;
        this.body = body;
        this.username = username;
        this.password = password;
        this.timeout = Optional.ofNullable(timeout).filter(StringUtils::isNotBlank).map(Duration::parse).map(Duration::toMilliseconds).orElse(2000L).intValue();
    }

    public TaskExecutionResult execute() {
        HttpClient httpClient = new HttpClientFactory().create(this.target, String.class, this.timeout);
        HttpHeaders httpHeaders = new HttpHeaders();
        String finalBody = XmlFunction.getSoapBody(this.username, this.password, this.body.toString());
        Supplier<ResponseEntity<String>> caller = () -> httpClient.post(this.uri, Optional.ofNullable(finalBody).orElse("{}"), (MultiValueMap<String, String>)httpHeaders);
        return HttpTask.httpCall(this.logger, caller);
    }
}

