/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.context;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.time.Duration;
import java.util.concurrent.TimeUnit;

public class SleepTask
implements Task {
    private final Logger logger;
    private final Duration duration;

    public SleepTask(Logger logger, @Input(value="duration") String duration) {
        this.logger = logger;
        this.duration = Duration.parse((String)duration);
    }

    public TaskExecutionResult execute() {
        this.logger.info("Start sleeping for " + this.duration);
        try {
            TimeUnit.MILLISECONDS.sleep(this.duration.toMilliseconds());
        }
        catch (InterruptedException e) {
            this.logger.error("Stop sleeping due to Interruption signal");
            return TaskExecutionResult.ko();
        }
        this.logger.info("Stop sleeping for " + this.duration);
        return TaskExecutionResult.ok();
    }
}

