/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MicrometerTimerStopTask
implements Task {
    protected static final String OUTPUT_TIMER_SAMPLE_DURATION = "micrometerTimerSampleDuration";
    private final Logger logger;
    private final Timer.Sample sample;
    private final Timer timer;
    private TimeUnit timeunit;

    public MicrometerTimerStopTask(Logger logger, @Input(value="sample") Timer.Sample sample, @Input(value="timer") Timer timer, @Input(value="timeunit") String timeunit) {
        this.logger = logger;
        this.sample = Objects.requireNonNull(sample);
        this.timer = Objects.requireNonNull(timer);
        this.timeunit = MicrometerTaskHelper.checkTimeUnit(timeunit);
    }

    public TaskExecutionResult execute() {
        try {
            long duration = this.sample.stop(this.timer);
            Duration durationObj = Duration.of(duration, ChronoUnit.NANOS);
            this.logger.info("Timer sample stopped and last for " + durationObj);
            MicrometerTaskHelper.logTimerState(this.logger, this.timer, this.timeunit);
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_TIMER_SAMPLE_DURATION, durationObj));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }
}

