/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MicrometerSummaryTask
implements Task {
    protected static final String OUTPUT_SUMMARY = "micrometerSummary";
    private final Logger logger;
    private final String name;
    private final String description;
    private String unit;
    private final List<String> tags;
    private final Integer bufferLength;
    private final Duration expiry;
    private final Long maxValue;
    private final Long minValue;
    private final Integer percentilePrecision;
    private final Boolean publishPercentilesHistogram;
    private final double[] percentiles;
    private final Double scale;
    private final long[] sla;
    private DistributionSummary distributionSummary;
    private final MeterRegistry registry;
    private final Double record;

    public MicrometerSummaryTask(Logger logger, @Input(value="name") String name, @Input(value="description") String description, @Input(value="unit") String unit, @Input(value="tags") List<String> tags, @Input(value="bufferLength") String bufferLength, @Input(value="expiry") String expiry, @Input(value="maxValue") String maxValue, @Input(value="minValue") String minValue, @Input(value="percentilePrecision") String percentilePrecision, @Input(value="publishPercentilesHistogram") Boolean publishPercentilesHistogram, @Input(value="percentiles") String percentiles, @Input(value="scale") String scale, @Input(value="sla") String sla, @Input(value="distributionSummary") DistributionSummary distributionSummary, @Input(value="registry") MeterRegistry registry, @Input(value="record") String record) {
        this.logger = logger;
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.tags = tags;
        this.bufferLength = MicrometerTaskHelper.checkIntOrNull(bufferLength);
        this.expiry = MicrometerTaskHelper.checkDurationOrNull(expiry);
        this.maxValue = MicrometerTaskHelper.checkLongOrNull(maxValue);
        this.minValue = MicrometerTaskHelper.checkLongOrNull(minValue);
        this.percentilePrecision = MicrometerTaskHelper.checkIntOrNull(percentilePrecision);
        this.publishPercentilesHistogram = publishPercentilesHistogram;
        this.percentiles = MicrometerTaskHelper.checkMapOrNull(percentiles, MicrometerTaskHelper::parsePercentilesList);
        this.scale = MicrometerTaskHelper.checkDoubleOrNull(scale);
        this.sla = MicrometerTaskHelper.checkMapOrNull(sla, MicrometerTaskHelper::parseSlaListToLongs);
        this.record = MicrometerTaskHelper.checkDoubleOrNull(record);
        this.distributionSummary = distributionSummary;
        this.registry = registry;
    }

    public TaskExecutionResult execute() {
        try {
            this.distributionSummary = Optional.ofNullable(this.distributionSummary).orElseGet(() -> this.retrieveSummary(this.registry));
            if (this.record != null) {
                this.distributionSummary.record(this.record.doubleValue());
                this.logger.info("Distribution summary updated by " + this.record);
            }
            this.logger.info("Distribution summary current total is " + this.distributionSummary.totalAmount());
            this.logger.info("Distribution summary current max is " + this.distributionSummary.max());
            this.logger.info("Distribution summary current mean is " + this.distributionSummary.mean());
            this.logger.info("Distribution summary current count is " + this.distributionSummary.count());
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_SUMMARY, this.distributionSummary));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private DistributionSummary retrieveSummary(MeterRegistry registry) {
        MeterRegistry registryToUse = MicrometerTaskHelper.checkRegistry(registry);
        DistributionSummary.Builder builder = DistributionSummary.builder((String)Objects.requireNonNull(this.name)).description(this.description).baseUnit(this.unit).distributionStatisticBufferLength(this.bufferLength).distributionStatisticExpiry(this.expiry).maximumExpectedValue(this.maxValue).minimumExpectedValue(this.minValue).percentilePrecision(this.percentilePrecision).publishPercentileHistogram(this.publishPercentilesHistogram).publishPercentiles(this.percentiles).sla(this.sla);
        Optional.ofNullable(this.scale).ifPresent(t -> builder.scale(this.scale.doubleValue()));
        Optional.ofNullable(this.tags).ifPresent(t -> builder.tags(t.toArray(new String[0])));
        return builder.register(registryToUse);
    }
}

