/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.ssh.CommandResult;
import com.chutneytesting.task.ssh.Commands;
import com.chutneytesting.task.ssh.Connection;
import com.chutneytesting.task.ssh.sshj.SshJClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class SshClientTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final Commands commands;

    public SshClientTask(Target target, Logger logger, @Input(value="commands") List<Object> commands) {
        this.target = target;
        this.logger = logger;
        this.commands = Commands.from(commands);
    }

    public TaskExecutionResult execute() {
        try {
            Connection connection = Connection.from(this.target);
            SshJClient sshClient = new SshJClient(connection);
            List<CommandResult> commandResults = this.commands.executeWith(sshClient);
            HashMap<String, List<CommandResult>> taskResult = new HashMap<String, List<CommandResult>>();
            taskResult.put("results", commandResults);
            return TaskExecutionResult.ok(taskResult);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

