/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.context;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Map;

public class ContextPutTask
implements Task {
    private final Logger logger;
    private final Map<String, Object> entries;

    public ContextPutTask(Logger logger, @Input(value="entries") Map<String, Object> entries) {
        this.logger = logger;
        this.entries = entries;
        this.assertExecutionIsPossible();
    }

    public TaskExecutionResult execute() {
        this.entries.forEach((k, v) -> this.logger.info("Adding to context " + k + " = " + v + " (" + v.getClass().getSimpleName() + ")"));
        return TaskExecutionResult.ok(this.entries);
    }

    private void assertExecutionIsPossible() {
        if (this.entries == null) {
            throw new IllegalArgumentException("Entries to put in context not found.");
        }
        if (this.entries.isEmpty()) {
            this.logger.info("Nothing to put in context");
        }
    }
}

