/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class XsdValidationTask
implements Task {
    private String xml;
    private String xsdPath;
    private Logger logger;

    public XsdValidationTask(Logger logger, @Input(value="xml") String xml, @Input(value="xsd") String xsdPath) {
        this.logger = logger;
        this.xml = xml;
        this.xsdPath = xsdPath;
    }

    public TaskExecutionResult execute() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            String fileUrl = XsdValidationTask.class.getResource(this.xsdPath).getFile();
            Schema schema = factory.newSchema(new File(fileUrl));
            Validator validator = schema.newValidator();
            try (StringReader sr = new StringReader(this.xml);){
                StreamSource ss = new StreamSource(sr);
                validator.validate(ss);
            }
        }
        catch (IOException | SAXException e) {
            this.logger.error("Exception: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
        return TaskExecutionResult.ok();
    }
}

