/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api;

import com.chutneytesting.environment.api.EnvironmentApi;
import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.exception.AlreadyExistingEnvironmentException;
import com.chutneytesting.environment.domain.exception.AlreadyExistingTargetException;
import com.chutneytesting.environment.domain.exception.CannotDeleteEnvironmentException;
import com.chutneytesting.environment.domain.exception.EnvironmentNotFoundException;
import com.chutneytesting.environment.domain.exception.InvalidEnvironmentNameException;
import com.chutneytesting.environment.domain.exception.TargetNotFoundException;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v2/environment"})
public class HttpEnvironmentApi
implements EnvironmentApi {
    private final EnvironmentApi delegate;

    HttpEnvironmentApi(EnvironmentApi delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={""}, produces={"application/json"})
    public Set<EnvironmentDto> listEnvironments() {
        return this.delegate.listEnvironments();
    }

    @Override
    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE') or hasAuthority('CAMPAIGN_WRITE') or hasAuthority('CAMPAIGN_EXECUTE') or hasAuthority('COMPONENT_WRITE')")
    @GetMapping(path={"/names"}, produces={"application/json"})
    public Set<String> listEnvironmentsNames() {
        return this.delegate.listEnvironmentsNames();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={""})
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException {
        return this.delegate.createEnvironment(environmentDto, false);
    }

    @Override
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto, boolean force) {
        throw new UnsupportedOperationException();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/{environmentName}"})
    public void deleteEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException, CannotDeleteEnvironmentException {
        this.delegate.deleteEnvironment(environmentName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/{environmentName}"})
    public void updateEnvironment(@PathVariable(value="environmentName") String environmentName, @RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, EnvironmentNotFoundException {
        this.delegate.updateEnvironment(environmentName, environmentDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={"/{environmentName}/target"}, produces={"application/json"})
    public Set<TargetDto> listTargets(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.delegate.listTargets(environmentName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(path={"/target"}, produces={"application/json"})
    public Set<TargetDto> listTargets() throws EnvironmentNotFoundException {
        return this.delegate.listTargets();
    }

    @Override
    @PreAuthorize(value="hasAuthority('COMPONENT_READ')")
    @GetMapping(path={"/target/names"}, produces={"application/json"})
    public Set<String> listTargetsNames() throws EnvironmentNotFoundException {
        return this.delegate.listTargetsNames();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(value={"/{environmentName}"})
    public EnvironmentDto getEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.delegate.getEnvironment(environmentName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(value={"/{environmentName}/target/{targetName}"})
    public TargetDto getTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        return this.delegate.getTarget(environmentName, targetName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(value={"/{environmentName}/target"})
    public void addTarget(@PathVariable(value="environmentName") String environmentName, @RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, AlreadyExistingTargetException {
        this.delegate.addTarget(environmentName, targetDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/{environmentName}/target/{targetName}"})
    public void deleteTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.delegate.deleteTarget(environmentName, targetName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/{environmentName}/target/{targetName}"})
    public void updateTarget(@PathVariable(value="environmentName") String environmentName, @PathVariable(value="targetName") String targetName, @RequestBody TargetDto targetDto) throws EnvironmentNotFoundException, TargetNotFoundException {
        this.delegate.updateTarget(environmentName, targetName, targetDto);
    }
}

