/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.infra;

import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.infra.JsonTarget;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JsonEnvironment {
    public String name;
    public String description;
    public List<JsonTarget> targets;

    public JsonEnvironment() {
    }

    public JsonEnvironment(String name, String description, List<JsonTarget> targets) {
        this.name = name;
        this.description = description;
        this.targets = targets;
    }

    public static JsonEnvironment from(Environment environment) {
        List<JsonTarget> targets = environment.targets.stream().map(JsonTarget::from).collect(Collectors.toList());
        return new JsonEnvironment(environment.name, environment.description, targets);
    }

    public Environment toEnvironment() {
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(Optional.ofNullable(this.targets).orElse(Collections.emptyList()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet())).build();
    }
}

