/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.domain;

import com.chutneytesting.environment.domain.SecurityInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Target {
    public final String url;
    public final Map<String, String> properties;
    public final SecurityInfo security;
    public final String name;
    public final String environment;

    private Target(String environment, String url, Map<String, String> properties, SecurityInfo security, String name) {
        this.environment = environment;
        this.url = url;
        this.properties = properties;
        this.security = security;
        this.name = name;
    }

    public static TargetBuilder builder() {
        return new TargetBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Target target = (Target)o;
        return Objects.equals(this.environment, target.environment) && Objects.equals(this.url, target.url) && Objects.equals(this.properties, target.properties) && Objects.equals(this.security, target.security) && Objects.equals(this.name, target.name);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.url, this.properties, this.security, this.name);
    }

    public String toString() {
        return "Target{environment=" + this.environment + ", url='" + this.url + "', properties=" + this.properties + ", security=" + this.security + ", name='" + this.name + "'}";
    }

    public static class TargetBuilder {
        private String name;
        private String environment;
        private String url;
        private Map<String, String> properties;
        private SecurityInfo security;

        private TargetBuilder() {
        }

        public Target build() {
            return new Target(Objects.requireNonNull(this.environment, "environment"), Objects.requireNonNull(this.url, "url"), Collections.unmodifiableMap(Optional.ofNullable(this.properties).orElse(Collections.emptyMap())), Optional.ofNullable(this.security).orElse(SecurityInfo.builder().build()), Objects.requireNonNull(this.name, "name"));
        }

        public TargetBuilder withName(String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        public TargetBuilder withEnvironment(String value) {
            this.environment = Objects.requireNonNull(value, "environment");
            return this;
        }

        public TargetBuilder withUrl(String value) {
            this.url = Objects.requireNonNull(value, "url");
            return this;
        }

        public TargetBuilder withProperties(Map<String, String> value) {
            this.properties = new HashMap<String, String>(value);
            return this;
        }

        public TargetBuilder withSecurity(SecurityInfo security) {
            this.security = Objects.requireNonNull(security, "security");
            return this;
        }

        public TargetBuilder copyOf(Target target) {
            Objects.requireNonNull(target, "target");
            this.withName(target.name);
            this.withEnvironment(target.environment);
            this.withUrl(target.url);
            this.withSecurity(target.security);
            this.withProperties(target.properties);
            return this;
        }
    }
}

