/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.dto;

import com.chutneytesting.environment.domain.SecurityInfo;
import com.chutneytesting.environment.domain.Target;
import com.chutneytesting.tools.Entry;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TargetDto {
    public final String name;
    public final String url;
    public final List<Entry> properties;
    public final String username;
    public final String password;
    public final String keyStore;
    public final String keyStorePassword;
    public final String keyPassword;
    public final String privateKey;

    public TargetDto(String name, String url, List<Entry> properties, String username, String password, String keyStore, String keyStorePassword, String keyPassword, String privateKey) {
        this.name = name.trim();
        this.url = url.trim();
        this.properties = this.nullToEmpty(properties);
        this.username = this.emptyToNull(username);
        this.password = this.emptyToNull(password);
        this.keyStore = this.emptyToNull(keyStore);
        this.keyStorePassword = this.emptyToNull(keyStorePassword);
        this.keyPassword = this.emptyToNull(keyPassword);
        this.privateKey = this.emptyToNull(privateKey);
    }

    public Target toTarget(String environment) {
        SecurityInfo.SecurityInfoBuilder securityInfo = SecurityInfo.builder().keyStore(this.keyStore).keyStorePassword(this.keyStorePassword).keyPassword(this.keyPassword).privateKey(this.privateKey);
        if (this.username != null || this.password != null) {
            securityInfo.credential(SecurityInfo.Credential.of(this.username, this.password));
        }
        return Target.builder().withName(this.name).withEnvironment(environment).withUrl(this.url).withProperties(this.propertiesToMap()).withSecurity(securityInfo.build()).build();
    }

    public static TargetDto from(Target target) {
        return new TargetDto(target.name, target.url, Entry.toEntryList(target.properties), Optional.ofNullable(target.security.credential).map(c -> c.username).orElse(null), Optional.ofNullable(target.security.credential).map(c -> c.password).orElse(null), Optional.ofNullable(target.security.keyStore).orElse(null), Optional.ofNullable(target.security.keyStorePassword).orElse(null), Optional.ofNullable(target.security.keyPassword).orElse(null), Optional.ofNullable(target.security.privateKey).orElse(null));
    }

    public Map<String, String> propertiesToMap() {
        return this.properties.stream().collect(Collectors.toMap(p -> p.key, p -> p.value));
    }

    public boolean hasCredential() {
        return !Strings.isNullOrEmpty((String)this.username) || !Strings.isNullOrEmpty((String)this.password);
    }

    private String emptyToNull(String s) {
        return "".equals(s) ? null : s;
    }

    private <T> List<T> nullToEmpty(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }
}

