/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.assertion;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.StepDefinitionSpi;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public class AssertAction
implements Action {
    private final String ASSERTS_INPUT_LABEL = "asserts";
    private final Logger logger;
    private final List<Map<String, Boolean>> asserts;
    private final StepDefinitionSpi stepDefinition;

    public AssertAction(Logger logger, @Input(value="asserts") List<Map<String, Boolean>> asserts, StepDefinitionSpi stepDefinition) {
        this.logger = logger;
        this.asserts = Optional.ofNullable(asserts).orElse(Collections.emptyList());
        this.stepDefinition = stepDefinition;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notEmptyListValidation(this.asserts, (String)"asserts")});
    }

    public ActionExecutionResult execute() {
        List stepDefinitionInputs = (List)this.stepDefinition.inputs().get("asserts");
        boolean allAssertionAreValid = IntStream.range(0, this.asserts.size()).mapToObj(index -> this.asserts.get(index).entrySet().stream().map(assertion -> this.checkAssertion((Map.Entry<String, Boolean>)assertion, (Map)stepDefinitionInputs.get(index)))).flatMap(Function.identity()).allMatch(valid -> valid);
        return allAssertionAreValid ? ActionExecutionResult.ok() : ActionExecutionResult.ko();
    }

    private Boolean checkAssertion(Map.Entry<String, Boolean> assertion, Map<String, Object> stepDefinitionAssertions) {
        if ("assert-true".equals(assertion.getKey())) {
            String stepDefinitionAssertion = (String)stepDefinitionAssertions.get(assertion.getKey());
            if (assertion.getValue().booleanValue()) {
                this.logger.info(stepDefinitionAssertion + " is True");
                return true;
            }
            this.logger.error(stepDefinitionAssertion + " is False");
            return false;
        }
        this.logger.error("Unknown assert type [" + assertion.getKey() + "]");
        return Boolean.FALSE;
    }
}

