/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.ssh;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.ssh.sshd.ChutneyCommandFactory;
import com.chutneytesting.action.ssh.sshd.NoShellFactory;
import com.chutneytesting.action.ssh.sshd.SshServerMock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.config.keys.DefaultAuthorizedKeysAuthenticator;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;
import org.slf4j.LoggerFactory;

public class SshServerStartAction
implements Action {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(SshServerStartAction.class);
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final int port;
    private final String host;
    private final String keyPair;
    private final List<String> sshUsernames;
    private final List<String> sshPasswords;
    private final String authorizedKeys;
    private final List<String> stubs;

    public SshServerStartAction(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="port") String port, @Input(value="bind-address") String host, @Input(value="private-key") String keyPair, @Input(value="usernames") List<String> usernames, @Input(value="passwords") List<String> passwords, @Input(value="authorized-keys") String authorizedKeys, @Input(value="responses") List<String> stubs) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.port = Integer.parseInt(Optional.ofNullable(port).orElseGet(() -> String.valueOf(this.getFreePort())));
        this.host = Optional.ofNullable(host).orElseGet(this::getHostAddress);
        this.keyPair = keyPair;
        this.sshUsernames = Optional.ofNullable(usernames).filter(l -> !l.isEmpty()).orElse(Collections.singletonList("test"));
        this.sshPasswords = Optional.ofNullable(passwords).filter(l -> !l.isEmpty()).orElse(Collections.singletonList("test"));
        this.authorizedKeys = Optional.ofNullable(authorizedKeys).orElse("default");
        this.stubs = Optional.ofNullable(stubs).orElse(Collections.emptyList());
    }

    public ActionExecutionResult execute() {
        SshServer sshServer = SshServer.setUpDefaultServer();
        SshServerMock mock = new SshServerMock(sshServer, this.stubs);
        sshServer.setPort(this.port);
        sshServer.setHost(this.host);
        sshServer.setKeyPairProvider(this.keyPairProvider());
        sshServer.setShellFactory((ShellFactory)new NoShellFactory(mock));
        sshServer.setCommandFactory((CommandFactory)new ChutneyCommandFactory(mock));
        sshServer.setPasswordAuthenticator(this.simplePasswordAuthenticator());
        sshServer.setPublickeyAuthenticator(this.publicKeyAuthenticator());
        this.logger.info("Try to start ssh server on port " + this.port);
        try {
            mock.start();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        this.createQuitFinallyAction(mock);
        return ActionExecutionResult.ok(this.toOutputs(mock));
    }

    private Map<String, Object> toOutputs(SshServerMock sshServer) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("sshServer", sshServer);
        return outputs;
    }

    private void createQuitFinallyAction(SshServerMock sshServer) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"ssh-server-stop", SshServerStartAction.class).withInput("ssh-server", (Object)sshServer).build());
        this.logger.info("SshServerStop finally action registered");
    }

    private KeyPairProvider keyPairProvider() {
        if (this.keyPair != null && !this.keyPair.isEmpty()) {
            Path keyPairPath = Paths.get(this.keyPair, new String[0]);
            if (Files.exists(keyPairPath, new LinkOption[0])) {
                return new FileKeyPairProvider(keyPairPath);
            }
            return new ClassLoadableResourceKeyPairProvider(this.keyPair);
        }
        return this.simpleKeyPairProvider();
    }

    private AbstractGeneratorHostKeyProvider simpleKeyPairProvider() {
        File rsaKey;
        SimpleGeneratorHostKeyProvider hostKeyProvider = new SimpleGeneratorHostKeyProvider();
        hostKeyProvider.setAlgorithm("RSA");
        try {
            rsaKey = File.createTempFile("chutney", "ssh_key_pair");
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        hostKeyProvider.setPath(rsaKey.toPath());
        return hostKeyProvider;
    }

    private PublickeyAuthenticator publicKeyAuthenticator() {
        if ("default".equals(this.authorizedKeys)) {
            return DefaultAuthorizedKeysAuthenticator.INSTANCE;
        }
        if ("rejectAll".equals(this.authorizedKeys)) {
            return RejectAllPublickeyAuthenticator.INSTANCE;
        }
        if ("acceptAll".equals(this.authorizedKeys)) {
            return AcceptAllPublickeyAuthenticator.INSTANCE;
        }
        Path path = Paths.get(this.authorizedKeys, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return new AuthorizedKeysAuthenticator(path);
        }
        throw new UncheckedIOException(new FileNotFoundException(path.toString()));
    }

    private int getFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        socket.close();
        return n;
    }

    private String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Cannot retrieve host IP address", (Throwable)e);
            return "0.0.0.0";
        }
    }

    private PasswordAuthenticator simplePasswordAuthenticator() {
        return (username, password, session) -> this.sshUsernames.contains(username) && this.sshPasswords.contains(password);
    }
}

