/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.sql;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.ActionsConfiguration;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.action.sql.core.DefaultSqlClientFactory;
import com.chutneytesting.action.sql.core.Records;
import com.chutneytesting.action.sql.core.SqlClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class SqlAction
implements Action {
    public static final String CONFIGURABLE_NB_LOGGED_ROW = "chutney.actions.sql.max-logged-rows";
    private static final Integer DEFAULT_NB_LOGGED_ROW = 30;
    private final Target target;
    private final Logger logger;
    private final List<String> statements;
    private final Integer nbLoggedRow;
    private final DefaultSqlClientFactory clientFactory = new DefaultSqlClientFactory();

    public SqlAction(Target target, Logger logger, ActionsConfiguration configuration, @Input(value="statements") List<String> statements, @Input(value="nbLoggedRow") Integer nbLoggedRow) {
        this.target = target;
        this.logger = logger;
        this.statements = statements;
        this.nbLoggedRow = Optional.ofNullable(nbLoggedRow).orElse(configuration.getInteger(CONFIGURABLE_NB_LOGGED_ROW, DEFAULT_NB_LOGGED_ROW));
    }

    public List<String> validateInputs() {
        Validator targetPropertiesValidation = Validator.of((Object)this.target).validate(t -> this.target.property("jdbcUrl").orElse(""), StringUtils::isNotBlank, "Missing Target property 'jdbcUrl'");
        return Validator.getErrorsFrom((Validator[])new Validator[]{targetPropertiesValidation, ActionValidatorsUtils.targetValidation((Target)this.target), ActionValidatorsUtils.notEmptyListValidation(this.statements, (String)"statements")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionExecutionResult execute() {
        SqlClient sqlClient = this.clientFactory.create(this.target);
        try {
            ArrayList records = new ArrayList();
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            AtomicBoolean failure = new AtomicBoolean(false);
            this.statements.forEach(statement -> {
                try {
                    Records result = sqlClient.execute((String)statement);
                    records.add(result);
                    this.logger.info(result.printable(this.nbLoggedRow));
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage() + " for " + statement + "; Vendor error code: " + e.getErrorCode());
                    records.add(sqlClient.emptyRecords());
                    failure.set(true);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    records.add(sqlClient.emptyRecords());
                    failure.set(true);
                }
            });
            if (this.statements.size() == 1) {
                outputs.put("affectedRows", ((Records)records.get((int)0)).affectedRows);
                outputs.put("rows", ((Records)records.get(0)).rows());
                outputs.put("firstRow", ((Records)records.get(0)).rows().get(0));
                outputs.put("recordResult", records);
            } else {
                outputs.put("recordResult", records);
            }
            ActionExecutionResult actionExecutionResult = failure.get() ? ActionExecutionResult.ko(outputs) : ActionExecutionResult.ok(outputs);
            return actionExecutionResult;
        }
        finally {
            if (sqlClient != null) {
                sqlClient.closeDatasource();
            }
        }
    }
}

