/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.selenium.SeleniumFindBehavior;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumGetAttributeAction
extends SeleniumAction
implements SeleniumFindBehavior {
    private static final String SELENIUM_OUTPUTS_KEY = "outputAttributeValue";
    private final String selector;
    private final String by;
    private final Integer wait;
    private final String attribute;

    public SeleniumGetAttributeAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="attribute") String attribute) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
        this.attribute = attribute;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElement.isPresent()) {
            this.logger.info("Get attribute from element : " + webElement.get());
            ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].style.background='yellow'", new Object[]{webElement.get()});
            if (StringUtils.isNotBlank((CharSequence)this.attribute)) {
                return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getAttribute(this.attribute));
            }
            return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getAttribute("value"));
        }
        this.takeScreenShot();
        this.logger.error("Cannot retrieve value of attribute " + this.attribute + " from element " + this.selector);
        return ActionExecutionResult.ko();
    }
}

