/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jms.consumer.bodySelector;

import com.chutneytesting.action.jms.consumer.bodySelector.BodySelector;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TextMessageBodySelector
implements BodySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextMessageBodySelector.class);

    TextMessageBodySelector() {
    }

    @Override
    public boolean match(Message message) {
        boolean matches;
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            Optional<String> messageBody = this.textContent(textMessage);
            matches = messageBody.map(this::match).orElse(Boolean.FALSE);
        } else {
            matches = false;
        }
        return matches;
    }

    public abstract boolean match(String var1);

    private Optional<String> textContent(TextMessage message) {
        try {
            String messageBody = message.getText();
            return Optional.ofNullable(messageBody);
        }
        catch (JMSException e) {
            LOGGER.warn("Unable to read text from JMS TextMessage", (Throwable)e);
            return Optional.empty();
        }
    }
}

