/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta.consumer;

import com.chutneytesting.action.jakarta.consumer.Consumer;
import com.chutneytesting.action.jakarta.consumer.bodySelector.BodySelector;
import com.chutneytesting.tools.Streams;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import java.util.Optional;

class SelectedMessageConsumer
implements Consumer {
    private final QueueBrowser browser;
    private final BodySelector bodySelector;
    private final int browserMaxDepth;

    SelectedMessageConsumer(QueueBrowser browser, BodySelector bodySelector, int browserMaxDepth) {
        this.browser = browser;
        this.bodySelector = bodySelector;
        this.browserMaxDepth = browserMaxDepth;
    }

    @Override
    public Optional<Message> getMessage() throws JMSException {
        Enumeration messageEnumeration = this.browser.getEnumeration();
        return Streams.toStream((Enumeration)messageEnumeration).limit(this.browserMaxDepth).filter(this.bodySelector::match).findFirst();
    }
}

