/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta;

import com.chutneytesting.action.jakarta.JakartaConnectionFactory;
import com.chutneytesting.action.jakarta.UncheckedJakartaException;
import com.chutneytesting.action.jakarta.consumer.Consumer;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class JakartaListenerAction
implements Action {
    private final Target target;
    private final Logger logger;
    private final String destination;
    private final String timeout;
    private final JakartaConnectionFactory jmsConnectionFactory = new JakartaConnectionFactory();
    private final String bodySelector;
    private final String selector;
    private final int browserMaxDepth;

    public JakartaListenerAction(Target target, Logger logger, @Input(value="destination") String destination, @Input(value="timeout") String timeout, @Input(value="bodySelector") String bodySelector, @Input(value="selector") String selector, @Input(value="browserMaxDepth") Integer browserMaxDepth) {
        this.target = target;
        this.logger = logger;
        this.destination = destination;
        this.timeout = (String)StringUtils.defaultIfEmpty((CharSequence)timeout, (CharSequence)"500 ms");
        this.bodySelector = bodySelector;
        this.selector = selector;
        this.browserMaxDepth = (Integer)ObjectUtils.defaultIfNull((Object)browserMaxDepth, (Object)30);
        if (browserMaxDepth != null && bodySelector == null) {
            logger.error("[WARNING] browserMaxDepth is only used if bodySelector is filled");
        }
        if (bodySelector != null && timeout != null) {
            logger.error("[WARNING] timeout is only used if bodySelector is NOT filled");
        }
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.destination, (String)"destination"), ActionValidatorsUtils.durationValidation((String)this.timeout, (String)"timeout"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (CloseableResource<Consumer> consumerCloseableResource = this.jmsConnectionFactory.createConsumer(this.target, this.destination, this.timeout, this.bodySelector, this.selector, this.browserMaxDepth);){
            Optional<Message> matchingMessage = ((Consumer)consumerCloseableResource.getResource()).getMessage();
            if (matchingMessage.isPresent()) {
                Message message = matchingMessage.get();
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    this.logger.info("Jms message received: " + textMessage.getText());
                    ActionExecutionResult actionExecutionResult = ActionExecutionResult.ok(JakartaListenerAction.toOutputs(textMessage));
                    return actionExecutionResult;
                }
                this.logger.error("JMS message type not handled: " + message.getClass().getSimpleName());
                return ActionExecutionResult.ko();
            }
            this.logger.error("No message available");
            return ActionExecutionResult.ko();
        }
        catch (UncheckedJakartaException | JMSException | IllegalArgumentException | IllegalStateException e) {
            this.logger.error(e);
        }
        return ActionExecutionResult.ko();
    }

    private static Map<String, Object> toOutputs(TextMessage message) throws JMSException {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("textMessage", message.getText());
        outputs.put("jmsProperties", JakartaListenerAction.getMessageProperties((Message)message));
        return outputs;
    }

    private static HashMap<String, Object> getMessageProperties(Message msg) throws JMSException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration srcProperties = msg.getPropertyNames();
        while (srcProperties.hasMoreElements()) {
            String propertyName = (String)srcProperties.nextElement();
            properties.put(propertyName, msg.getObjectProperty(propertyName));
        }
        return properties;
    }
}

