/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.jakarta;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.core.server.ActiveMQServer;

public class JakartaBrokerStopAction
implements Action {
    private final Logger logger;
    private final ActiveMQServer brokerService;

    public JakartaBrokerStopAction(Logger logger, @Input(value="jakarta-broker-service") ActiveMQServer brokerService) {
        this.logger = logger;
        this.brokerService = brokerService;
    }

    public List<String> validateInputs() {
        Validator jmsBrokerValidation = Validator.of((Object)this.brokerService).validate(Objects::nonNull, "No jakarta-broker-service provided");
        return Validator.getErrorsFrom((Validator[])new Validator[]{jmsBrokerValidation});
    }

    public ActionExecutionResult execute() {
        this.logger.info("Call jms broker shutdown");
        try {
            this.brokerService.stop();
            return ActionExecutionResult.ok();
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return ActionExecutionResult.ko();
        }
    }
}

