/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.context;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DebugAction
implements Action {
    private final Logger logger;
    private final Map<String, Object> inputs;
    private final List<String> filter;

    public DebugAction(Logger logger, Map<String, Object> inputs, @Input(value="filters") List<String> filter) {
        this.logger = logger;
        this.inputs = inputs;
        this.filter = Optional.ofNullable(filter).orElseGet(Collections::emptyList);
    }

    public ActionExecutionResult execute() {
        this.inputs.entrySet().stream().filter(entry -> this.filter.isEmpty() || this.filter.contains(entry.getKey())).forEach(entry -> this.logger.info((String)entry.getKey() + " : [" + entry.getValue() + "]"));
        return ActionExecutionResult.ok();
    }
}

