/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.FinallyAction;
import com.chutneytesting.action.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class AmqpCreateBoundTemporaryQueueAction
implements Action {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String exchangeName;
    private final String routingKey;
    private final String queueName;
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;

    public AmqpCreateBoundTemporaryQueueAction(Target target, @Input(value="exchange-name") String exchangeName, @Input(value="routing-key") String routingKey, @Input(value="queue-name") String queueName, Logger logger, FinallyActionRegistry finallyActionRegistry) {
        this.target = target;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.queueName = queueName;
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), ActionValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"exchange-name"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            ActionExecutionResult actionExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    this.createQueue(this.queueName, channel);
                    this.bindQueue(channel, this.queueName);
                    this.createQuitFinallyActions();
                    actionExecutionResult = ActionExecutionResult.ok(Collections.singletonMap("queueName", this.queueName));
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return actionExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return ActionExecutionResult.ko();
        }
    }

    private void bindQueue(Channel channel, String queueName) throws IOException {
        String routingKey = Optional.ofNullable(this.routingKey).orElse(queueName);
        channel.queueBind(queueName, this.exchangeName, routingKey);
        this.logger.info("Created AMQP binding " + this.exchangeName + " (with " + this.routingKey + ") -> " + queueName);
    }

    private void createQueue(String queueName, Channel channel) throws IOException {
        channel.queueDeclare(queueName, true, false, false, null);
        this.logger.info("Created AMQP Queue with name: " + queueName);
    }

    private void createQuitFinallyActions() {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-unbind-queue", AmqpCreateBoundTemporaryQueueAction.class).withTarget(this.target).withInput("queue-name", (Object)this.queueName).withInput("exchange-name", (Object)this.exchangeName).withInput("routing-key", (Object)this.routingKey).build());
        this.logger.info("Registered unbinding queue finally action");
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"amqp-delete-queue", (String)AmqpCreateBoundTemporaryQueueAction.class.getSimpleName()).withTarget(this.target).withInput("queue-name", (Object)this.queueName).build());
        this.logger.info("Registered delete queue finally action");
    }
}

