/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.function;

import com.chutneytesting.action.common.XmlUtils;
import com.chutneytesting.action.spi.SpelFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.Filter;
import org.jdom2.xpath.XPathExpression;

public class XPathFunction {
    @SpelFunction
    public static Object xpath(String documentAsString, String xpath) throws XmlUtils.InvalidXmlDocumentException, XmlUtils.InvalidXPathException {
        return XPathFunction.xpathNs(documentAsString, xpath, new HashMap<String, String>());
    }

    @SpelFunction
    public static Object xpathNs(String documentAsString, String xpath, Map<String, String> nsPrefixes) throws XmlUtils.InvalidXmlDocumentException, XmlUtils.InvalidXPathException {
        Document document = XmlUtils.toDocument(documentAsString);
        XPathExpression<Object> xpathExpression = XmlUtils.compileXPath(xpath, nsPrefixes);
        Object jDomObject = xpathExpression.evaluateFirst((Object)document);
        return XPathFunction.unwrapJdomSimpleObject(jDomObject);
    }

    private static Object unwrapJdomSimpleObject(Object jDomObject) {
        Object result;
        if (jDomObject instanceof Text) {
            Text text = (Text)jDomObject;
            result = text.getText();
        } else if (jDomObject instanceof Attribute) {
            Attribute attribute = (Attribute)jDomObject;
            result = attribute.getValue();
        } else if (jDomObject instanceof Element) {
            Element element = (Element)jDomObject;
            result = XPathFunction.unwrapJdomElement(element);
        } else {
            result = jDomObject;
        }
        return result;
    }

    private static Object unwrapJdomElement(Element jDomObject) {
        List cdata = jDomObject.getContent((Filter)new ContentFilter(2));
        List contents = jDomObject.getContent(new ContentFilter(8).negate());
        Object result = cdata.size() == 1 ? XPathFunction.unwrapJdomSimpleObject(cdata.get(0)) : (contents.size() == 1 ? XPathFunction.unwrapJdomSimpleObject(contents.get(0)) : jDomObject);
        return result;
    }
}

