package com.chutneytesting.action.micrometer;

import static io.micrometer.core.instrument.Metrics.globalRegistry;

import com.chutneytesting.action.spi.SpelFunction;
import io.micrometer.core.instrument.MeterRegistry;

public class MicrometerFunctions {

    @SpelFunction
    public static MeterRegistry micrometerRegistry(String registryClassName) {
        if (registryClassName == null || registryClassName.isBlank()) {
            return globalRegistry;
        }

        return globalRegistry.getRegistries().stream()
            .filter(mr -> mr.getClass().getSimpleName().contains(registryClassName))
            .findFirst()
            .orElse(globalRegistry);
    }
}
