/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.selenium.SeleniumFindBehavior;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumSwitchToAction
extends SeleniumAction
implements SeleniumFindBehavior {
    private static final String SELENIUM_OUTPUTS_KEY = "outputSwitchTo";
    private final String selector;
    private final String by;
    private final Integer wait;
    private final String switchType;

    public SeleniumSwitchToAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait, @Input(value="switchType") String switchType) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
        this.switchType = switchType;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        switch (Optional.ofNullable(this.switchType).orElse("")) {
            case "Frame": {
                if (!webElement.isPresent()) break;
                this.webDriver.switchTo().frame((WebElement)webElement.get());
                this.logger.info("Switch to frame");
                break;
            }
            case "Window": {
                if (webElement.isEmpty()) {
                    if (this.selector != null && this.by == null) {
                        this.webDriver.switchTo().window(this.selector);
                        this.logger.info("Switch to window");
                        return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)this.webDriver.getWindowHandle());
                    }
                    this.webDriver.switchTo().defaultContent();
                    this.logger.info("Switch to default content");
                    break;
                }
                return ActionExecutionResult.ko();
            }
            case "Popup": {
                if (webElement.isEmpty()) {
                    Set windowHandlers = this.webDriver.getWindowHandles();
                    String parentWindowHandler = this.webDriver.getWindowHandle();
                    String popupHandler = windowHandlers.stream().filter(h -> !parentWindowHandler.equals(h)).findFirst().get();
                    this.webDriver.switchTo().window(popupHandler);
                    this.logger.info("Switch to popup");
                    return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)popupHandler);
                }
                return ActionExecutionResult.ko();
            }
            case "AlertOk": {
                try {
                    this.webDriver.switchTo().alert().accept();
                    this.logger.info("Switch to alert and click on the OK button");
                    return ActionExecutionResult.ok();
                }
                catch (Exception e) {
                    return ActionExecutionResult.ko();
                }
            }
            case "AlertCancel": {
                try {
                    this.webDriver.switchTo().alert().dismiss();
                    this.logger.info("Switch to alert and click on the Cancel button");
                    return ActionExecutionResult.ok();
                }
                catch (Exception e) {
                    return ActionExecutionResult.ko();
                }
            }
            default: {
                this.webDriver.switchTo().defaultContent();
                this.logger.info("Switch to default content");
            }
        }
        return ActionExecutionResult.ok();
    }
}

