/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.selenium;

import com.chutneytesting.action.selenium.SeleniumAction;
import com.chutneytesting.action.selenium.SeleniumFindBehavior;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumGetTextAction
extends SeleniumAction
implements SeleniumFindBehavior {
    private static final String SELENIUM_OUTPUTS_KEY = "outputGetText";
    private final String selector;
    private final String by;
    private final Integer wait;

    public SeleniumGetTextAction(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public ActionExecutionResult executeSeleniumAction() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElement.isPresent()) {
            this.logger.info("Get text from element : " + webElement.get());
            ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].style.background='yellow'", new Object[]{webElement.get()});
            if (!((WebElement)webElement.get()).getText().isEmpty()) {
                return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getText());
            }
            return ActionExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getAttribute("value"));
        }
        this.takeScreenShot();
        this.logger.error("Cannot retrieve element to get text from.");
        return ActionExecutionResult.ko();
    }
}

