/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.mongo;

import com.chutneytesting.action.mongo.DefaultMongoDatabaseFactory;
import com.chutneytesting.action.mongo.MongoActionValidatorsUtils;
import com.chutneytesting.action.mongo.MongoDatabaseFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.chutneytesting.tools.CloseableResource;
import com.google.common.base.Ascii;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import org.bson.Document;

public class MongoInsertAction
implements Action {
    private final MongoDatabaseFactory mongoDatabaseFactory = new DefaultMongoDatabaseFactory();
    private final Target target;
    private final Logger logger;
    private final String collection;
    private final String document;

    public MongoInsertAction(Target target, Logger logger, @Input(value="collection") String collection, @Input(value="document") String document) {
        this.target = target;
        this.logger = logger;
        this.collection = collection;
        this.document = document;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.collection, (String)"collection"), ActionValidatorsUtils.notBlankStringValidation((String)this.document, (String)"document"), MongoActionValidatorsUtils.mongoTargetValidation(this.target)});
    }

    public ActionExecutionResult execute() {
        ActionExecutionResult actionExecutionResult;
        block8: {
            CloseableResource<MongoDatabase> database = this.mongoDatabaseFactory.create(this.target);
            try {
                ((MongoDatabase)database.getResource()).getCollection(this.collection).insertOne((Object)Document.parse((String)this.document));
                this.logger.info("Inserted in Mongo collection '" + this.collection + "':\n\t" + Ascii.truncate((CharSequence)this.document.replace("\n", "\n\t"), (int)50, (String)"..."));
                actionExecutionResult = ActionExecutionResult.ok();
                if (database == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (database != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(e.getMessage());
                    return ActionExecutionResult.ko();
                }
            }
            database.close();
        }
        return actionExecutionResult;
    }
}

