/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class AmqpBasicPublishAction
implements Action {
    private static final String CONTENT_TYPE = "content_type";
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String exchangeName;
    private final String routingKey;
    private final Map<String, Object> headers;
    private final Map<String, String> properties;
    private final String payload;
    private final Logger logger;

    public AmqpBasicPublishAction(Target target, @Input(value="exchange-name") String exchangeName, @Input(value="routing-key") String routingKey, @Input(value="headers") Map<String, Object> headers, @Input(value="properties") Map<String, String> properties, @Input(value="payload") String payload, Logger logger) {
        this.target = target;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.properties = properties != null ? properties : Collections.emptyMap();
        this.payload = payload;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.exchangeName, (String)"exchange-name"), ActionValidatorsUtils.notBlankStringValidation((String)this.payload, (String)"payload"), ActionValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.newConnection(this.target);){
            ActionExecutionResult actionExecutionResult;
            block14: {
                Channel channel = connection.createChannel();
                try {
                    AMQP.BasicProperties basicProperties = this.buildProperties();
                    channel.basicPublish(this.exchangeName, this.routingKey, basicProperties, this.payload.getBytes());
                    this.logger.info("Published AMQP Message on " + this.exchangeName + " with routing key: " + this.routingKey);
                    actionExecutionResult = ActionExecutionResult.ok(this.outputs(basicProperties, this.payload));
                    if (channel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return actionExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return ActionExecutionResult.ko();
        }
    }

    public Map<String, Object> outputs(AMQP.BasicProperties basicProperties, String payload) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("payload", payload);
        results.put("headers", basicProperties.getHeaders().entrySet().stream().map(Object::toString).collect(Collectors.joining(";", "[", "]")));
        return results;
    }

    private AMQP.BasicProperties buildProperties() {
        AMQP.BasicProperties.Builder basicPropertiesBuilder = new AMQP.BasicProperties.Builder().appId("testing-app");
        if (this.properties.containsKey(CONTENT_TYPE)) {
            basicPropertiesBuilder.contentType(this.properties.get(CONTENT_TYPE));
        }
        basicPropertiesBuilder.headers(this.headers);
        return basicPropertiesBuilder.build();
    }
}

