/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.amqp;

import com.chutneytesting.action.amqp.ConnectionFactoryFactory;
import com.chutneytesting.action.amqp.consumer.ConsumerSupervisor;
import com.chutneytesting.action.amqp.consumer.QueueingConsumer;
import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AmqpBasicConsumeAction
implements Action {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String queueName;
    private final Integer nbMessages;
    private final String selector;
    private final String timeout;
    private final Boolean ack;
    private final Logger logger;

    public AmqpBasicConsumeAction(Target target, @Input(value="queue-name") String queueName, @Input(value="nb-messages") Integer nbMessages, @Input(value="selector") String selector, @Input(value="timeout") String timeout, @Input(value="ack") Boolean ack, Logger logger) {
        this.target = target;
        this.queueName = queueName;
        this.logger = logger;
        this.nbMessages = (Integer)ObjectUtils.defaultIfNull((Object)nbMessages, (Object)1);
        this.timeout = (String)StringUtils.defaultIfEmpty((CharSequence)timeout, (CharSequence)"10 sec");
        this.selector = selector;
        this.ack = (Boolean)ObjectUtils.defaultIfNull((Object)ack, (Object)true);
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), ActionValidatorsUtils.targetValidation((Target)this.target), ActionValidatorsUtils.durationValidation((String)this.timeout, (String)"timeout")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionExecutionResult execute() {
        long originalDuration = Duration.parse((String)this.timeout).toMilliseconds();
        ConsumerSupervisor instance = ConsumerSupervisor.getInstance();
        Connection connection = null;
        Channel channel = null;
        try {
            Pair<Boolean, Long> waitingResult = instance.waitUntilQueueAvailable(this.queueName, originalDuration, this.logger);
            boolean lockAcquired = (Boolean)waitingResult.getLeft();
            if (!lockAcquired) {
                ActionExecutionResult actionExecutionResult = ActionExecutionResult.ko();
                try {
                    this.closeChannel(channel);
                    this.closeConnection(connection);
                    return actionExecutionResult;
                }
                finally {
                    instance.unlock(this.queueName);
                }
            }
            connection = this.connectionFactoryFactory.newConnection(this.target);
            channel = connection.createChannel();
            long consumingDuration = (Long)waitingResult.getRight();
            QueueingConsumer.Result result = new QueueingConsumer(channel, this.queueName, this.nbMessages, this.selector, consumingDuration, this.ack).consume();
            if (result.messages.size() != this.nbMessages.intValue()) {
                this.logger.error("Unable to get the expected number of messages [" + this.nbMessages + "] during " + this.timeout + ".");
                ActionExecutionResult actionExecutionResult = ActionExecutionResult.ko();
                try {
                    this.closeChannel(channel);
                    this.closeConnection(connection);
                    return actionExecutionResult;
                }
                finally {
                    instance.unlock(this.queueName);
                }
            }
            this.logger.info("Message(s) found in " + result.consumeDuration);
            ActionExecutionResult actionExecutionResult = ActionExecutionResult.ok(this.extractOutputs(result));
            try {
                this.closeChannel(channel);
                this.closeConnection(connection);
                return actionExecutionResult;
            }
            finally {
                instance.unlock(this.queueName);
            }
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            ActionExecutionResult actionExecutionResult = ActionExecutionResult.ko();
            return actionExecutionResult;
        }
        finally {
            try {
                this.closeChannel(channel);
                this.closeConnection(connection);
            }
            finally {
                instance.unlock(this.queueName);
            }
        }
    }

    private Map<String, Object> extractOutputs(QueueingConsumer.Result result) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("body", result.messages);
        results.put("payloads", result.payloads);
        results.put("headers", result.headers);
        return results;
    }

    private void closeConnection(Connection connection) {
        if (connection != null && connection.isOpen()) {
            try {
                connection.close(1000);
            }
            catch (IOException e) {
                this.logger.error("Error during connection closing: " + e.getMessage());
            }
        }
    }

    private void closeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException | TimeoutException e) {
                this.logger.error("Error during channel closing: " + e.getMessage());
            }
        }
    }
}

