/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.ssh.sshj;

import com.chutneytesting.action.ssh.sshj.Command;
import com.chutneytesting.action.ssh.sshj.CommandResult;
import com.chutneytesting.action.ssh.sshj.SshClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger LOGGER = LoggerFactory.getLogger(Commands.class);
    public final List<Command> all;

    private Commands(List<Command> commands) {
        this.all = commands;
    }

    public static Commands from(List<Object> commands) {
        List<Command> cmds = Optional.ofNullable(commands).orElse(Collections.emptyList()).stream().map(Commands::buildCommand).collect(Collectors.toList());
        return new Commands(cmds);
    }

    private static Command buildCommand(Object command) {
        if (command instanceof String) {
            return new Command((String)command);
        }
        if (command instanceof Map) {
            return new Command((String)((Map)command).get("command"), (String)((Map)command).get("timeout"));
        }
        throw new IllegalStateException("Unable to understand command: " + command.toString());
    }

    public List<CommandResult> executeWith(SshClient sshClient) throws IOException {
        ArrayList<CommandResult> results = new ArrayList<CommandResult>();
        for (Command command : this.all) {
            LOGGER.debug("COMMANDS :: {}", (Object)command);
            CommandResult result = command.executeWith(sshClient);
            results.add(result);
            LOGGER.debug("RESULT :: {}", (Object)result);
        }
        return results;
    }
}

