/*
 * Decompiled with CFR 0.152.
 */
package com.chrisplus.rootmanager.utils;

import com.chrisplus.rootmanager.container.Command;
import com.chrisplus.rootmanager.container.Mount;
import com.chrisplus.rootmanager.container.Shell;
import com.chrisplus.rootmanager.exception.PermissionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class Remounter {
    private static final String MOUNT_FILE = "/proc/mounts";

    public static boolean remount(String file, String mountType) {
        if (file.endsWith("/") && !file.equals("/")) {
            file = file.substring(0, file.lastIndexOf("/"));
        }
        boolean foundMount = false;
        List<Mount> mounts = Remounter.getMounts();
        if (mounts == null || mounts.isEmpty()) {
            return false;
        }
        while (!foundMount) {
            for (Mount mount : mounts) {
                if (!file.equals(mount.getMountPoint().toString())) continue;
                foundMount = true;
                break;
            }
            if (foundMount) continue;
            file = new File(file).getParent().toString();
        }
        Mount mountPoint = Remounter.getMountPoint(file);
        boolean isMountMode = mountPoint.getFlags().contains(mountType.toLowerCase());
        if (!isMountMode) {
            Command command = new Command(new String[]{"busybox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "toolbox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath(), "/system/bin/toolbox mount -o remount," + mountType.toLowerCase() + " " + mountPoint.getDevice().getAbsolutePath() + " " + mountPoint.getMountPoint().getAbsolutePath()}){

                @Override
                public void onUpdate(int id, String message) {
                }

                @Override
                public void onFinished(int id) {
                }
            };
            try {
                Shell.startRootShell().add(command).waitForFinish();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (PermissionException e) {
                e.printStackTrace();
            }
        }
        return (mountPoint = Remounter.getMountPoint(file)).getFlags().contains(mountType.toLowerCase());
    }

    private static Mount getMountPoint(String file) {
        List<Mount> mounts = Remounter.getMounts();
        if (mounts == null || mounts.isEmpty()) {
            return null;
        }
        File path = new File(file);
        while (path != null) {
            for (Mount mount : mounts) {
                if (!mount.getMountPoint().equals(path)) continue;
                return mount;
            }
        }
        return null;
    }

    private static List<Mount> getMounts() {
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new FileReader(MOUNT_FILE));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        ArrayList<Mount> mounts = new ArrayList<Mount>();
        try {
            String line;
            while ((line = lnr.readLine()) != null) {
                String[] fields = line.split(" ");
                mounts.add(new Mount(new File(fields[0]), new File(fields[1]), fields[2], fields[3]));
            }
            lnr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mounts;
    }
}

