/*
 * Decompiled with CFR 0.152.
 */
package com.chrisplus.rootmanager.container;

import com.chrisplus.rootmanager.container.Shell;
import com.chrisplus.rootmanager.utils.RootUtils;
import java.io.IOException;

public abstract class Command {
    private String[] commands;
    private boolean isFinished;
    private int exitCode;
    private long timeout;
    private int id = RootUtils.generateCommandID();

    public Command(String ... commands) {
        this(300000, commands);
    }

    public Command(int timeout, String ... commands) {
        this.timeout = timeout;
        this.commands = commands;
    }

    public abstract void onUpdate(int var1, String var2);

    public abstract void onFinished(int var1);

    public int getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExitCode(int code) {
        Command command = this;
        synchronized (command) {
            this.exitCode = code;
            this.isFinished = true;
            this.onFinished(this.id);
            this.notifyAll();
        }
    }

    public void terminate(String reason) {
        try {
            RootUtils.Log("Terminate all shells with reason " + reason);
            Shell.closeAll();
            this.setExitCode(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            RootUtils.Log("Terminate all shells and io exception happens");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForFinish(long timeout) throws InterruptedException {
        Command command = this;
        synchronized (command) {
            while (!this.isFinished) {
                this.wait(timeout);
                if (this.isFinished) continue;
                this.isFinished = true;
                RootUtils.Log("Timeout Exception has occurred.");
                this.terminate("Timeout Exception");
            }
        }
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int keepAlive() throws InterruptedException {
        Command command = this;
        synchronized (command) {
            while (!this.isFinished) {
                this.wait();
            }
        }
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForFinish() throws InterruptedException {
        Command command = this;
        synchronized (command) {
            this.waitForFinish(this.timeout);
        }
        return this.exitCode;
    }

    public String getCommand() {
        if (this.commands == null || this.commands.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.commands.length; ++i) {
            sb.append(this.commands[i]);
            sb.append('\n');
        }
        String command = sb.toString();
        RootUtils.Log("Sending command(s): " + command);
        return command;
    }
}

