/*
 * Decompiled with CFR 0.152.
 */
package com.chrisplus.rootmanager.container;

import com.chrisplus.rootmanager.container.Command;
import com.chrisplus.rootmanager.exception.PermissionException;
import com.chrisplus.rootmanager.utils.RootUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class Shell {
    private static final String TAG = Shell.class.getSimpleName();
    private static final String token = "F*D^W@#FGF";
    private static int shellTimeout = 10000;
    private static String error = "";
    private static Shell rootShell = null;
    private static Shell customShell = null;
    private final Process proc;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final List<Command> commands = new ArrayList<Command>();
    private boolean close = false;
    private Runnable input = new Runnable(){

        @Override
        public void run() {
            try {
                Shell.this.writeCommands();
            }
            catch (IOException e) {
                RootUtils.Log(e.getMessage());
            }
        }
    };
    private Runnable output = new Runnable(){

        @Override
        public void run() {
            try {
                Shell.this.readOutput();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    };

    private Shell(String cmd) throws IOException, TimeoutException, PermissionException {
        RootUtils.Log(TAG, "Starting shell: " + cmd);
        this.proc = new ProcessBuilder(cmd).redirectErrorStream(true).start();
        this.in = new DataInputStream(this.proc.getInputStream());
        this.out = new DataOutputStream(this.proc.getOutputStream());
        Worker worker = new Worker(this.proc, this.in, this.out);
        worker.start();
        try {
            worker.join(shellTimeout);
            if (worker.exit == -911) {
                this.proc.destroy();
                throw new TimeoutException(error);
            }
            if (worker.exit == -42) {
                this.proc.destroy();
                throw new PermissionException("Root Access Denied");
            }
            new Thread(this.input, "Shell Input").start();
            new Thread(this.output, "Shell Output").start();
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw new TimeoutException();
        }
    }

    public static Shell getOpenShell() {
        if (rootShell != null) {
            return rootShell;
        }
        if (customShell != null) {
            return customShell;
        }
        return null;
    }

    public static Shell startRootShell() throws IOException, TimeoutException, PermissionException {
        return Shell.startRootShell(shellTimeout);
    }

    public static Shell startRootShell(int timeout) throws IOException, TimeoutException, PermissionException {
        shellTimeout = timeout;
        if (rootShell == null) {
            RootUtils.Log("Starting Root Shell!");
            String cmd = "su";
            int retries = 0;
            while (rootShell == null) {
                try {
                    rootShell = new Shell(cmd);
                }
                catch (IOException e) {
                    if (retries++ < 5) continue;
                    RootUtils.Log("Could not start shell");
                    throw e;
                }
            }
        } else {
            RootUtils.Log("Using Existing Root Shell!");
        }
        return rootShell;
    }

    public static Shell startCustomShell(String shellPath) throws IOException, TimeoutException, PermissionException {
        return Shell.startCustomShell(shellPath, shellTimeout);
    }

    public static Shell startCustomShell(String shellPath, int timeout) throws IOException, TimeoutException, PermissionException {
        shellTimeout = timeout;
        if (customShell == null) {
            RootUtils.Log("Starting Custom Shell!");
            customShell = new Shell(shellPath);
        } else {
            RootUtils.Log("Using Existing Custom Shell!");
        }
        return customShell;
    }

    public static void runRootCommand(Command command) throws IOException, TimeoutException, PermissionException {
        Shell.startRootShell().add(command);
    }

    public static void closeCustomShell() throws IOException {
        if (customShell == null) {
            return;
        }
        customShell.close();
    }

    public static void closeRootShell() throws IOException {
        if (rootShell == null) {
            return;
        }
        rootShell.close();
    }

    public static void closeAll() throws IOException {
        Shell.closeRootShell();
        Shell.closeCustomShell();
    }

    public static boolean isCustomShellOpen() {
        return customShell != null;
    }

    public static boolean isRootShellOpen() {
        return rootShell != null;
    }

    public static boolean isAnyShellOpen() {
        if (rootShell != null) {
            return true;
        }
        return customShell != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommands() throws IOException {
        try {
            DataOutputStream out;
            int write = 0;
            while (true) {
                List<Command> list = this.commands;
                synchronized (list) {
                    while (!this.close && write >= this.commands.size()) {
                        this.commands.wait();
                    }
                    out = this.out;
                }
                if (write < this.commands.size()) {
                    Command next = this.commands.get(write);
                    next.writeCommand(out);
                    String line = "\necho F*D^W@#FGF " + write + " $?\n";
                    out.write(line.getBytes());
                    out.flush();
                    ++write;
                    continue;
                }
                if (this.close) break;
            }
            out.write("\nexit 0\n".getBytes());
            out.flush();
            out.close();
            RootUtils.Log("Closing shell");
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    private void readOutput() throws IOException, InterruptedException {
        String line;
        Command command = null;
        int read = 0;
        while ((line = this.in.readLine()) != null) {
            String[] fields;
            int pos;
            if (command == null) {
                if (read >= this.commands.size()) {
                    if (!this.close) continue;
                    break;
                }
                command = this.commands.get(read);
            }
            if ((pos = line.indexOf(token)) > 0) {
                command.onUpdate(command.getID(), line.substring(0, pos));
            }
            if (pos >= 0 && (fields = (line = line.substring(pos)).split(" ")).length >= 2 && fields[1] != null) {
                int id = 0;
                try {
                    id = Integer.parseInt(fields[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int exitCode = -1;
                try {
                    exitCode = Integer.parseInt(fields[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (id == read) {
                    command.setExitCode(exitCode);
                    ++read;
                    command = null;
                    continue;
                }
            }
            command.onUpdate(command.getID(), line);
        }
        RootUtils.Log("Read all output");
        this.proc.waitFor();
        this.proc.destroy();
        RootUtils.Log("Shell destroyed");
        while (read < this.commands.size()) {
            if (command == null) {
                command = this.commands.get(read);
            }
            command.terminate("Unexpected Termination.");
            command = null;
            ++read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command add(Command command) throws IOException {
        if (this.close) {
            throw new IllegalStateException("Unable to add commands to a closed shell");
        }
        List<Command> list = this.commands;
        synchronized (list) {
            this.commands.add(command);
            this.commands.notifyAll();
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this == rootShell) {
            rootShell = null;
        }
        if (this == customShell) {
            customShell = null;
        }
        List<Command> list = this.commands;
        synchronized (list) {
            this.close = true;
            this.commands.notifyAll();
        }
    }

    public int countCommands() {
        return this.commands.size();
    }

    public void waitFor() throws IOException, InterruptedException {
        this.close();
        if (this.commands.size() > 0) {
            Command command = this.commands.get(this.commands.size() - 1);
            command.waitForFinish();
        }
    }

    protected static class Worker
    extends Thread {
        public int exit = -911;
        public Process proc;
        public DataInputStream in;
        public DataOutputStream out;

        private Worker(Process proc, DataInputStream in, DataOutputStream out) {
            this.proc = proc;
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                this.out.write("echo Started\n".getBytes());
                this.out.flush();
                while (true) {
                    String line;
                    if ((line = this.in.readLine()) == null) {
                        throw new EOFException();
                    }
                    if ("".equals(line)) continue;
                    if ("Started".equals(line)) {
                        this.exit = 1;
                        break;
                    }
                    error = "unkown error occured.";
                }
            }
            catch (IOException e) {
                this.exit = -42;
                if (e.getMessage() != null) {
                    error = e.getMessage();
                }
                error = "RootAccess denied?.";
            }
        }
    }
}

