/*
 * Decompiled with CFR 0.152.
 */
package com.chrisplus.rootmanager.container;

import com.chrisplus.rootmanager.utils.RootUtils;

public class Result {
    private String message;
    private int statusCode;

    private Result() {
    }

    public static ResultBuilder newBuilder() {
        return new ResultBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Boolean getResult() {
        RootUtils.Log("Status Code is " + this.statusCode);
        if (this.statusCode == 0) {
            return true;
        }
        if (this.statusCode <= 100) {
            return true;
        }
        return false;
    }

    public static class ResultBuilder {
        private ResultEnum inEnum = null;

        public ResultBuilder setCommandSuccess() {
            this.inEnum = ResultEnum.RUNCOMMAND_SUCCESS;
            return this;
        }

        public ResultBuilder setCommandFailedTimeout() {
            this.inEnum = ResultEnum.RUNCOMMAND_FAILED_TIMEOUT;
            return this;
        }

        public ResultBuilder setCommandFailedDenied() {
            this.inEnum = ResultEnum.RUNCOMMAND_FAILED_DENIED;
            return this;
        }

        public ResultBuilder setCommandFailedInterrupted() {
            this.inEnum = ResultEnum.RUNCOMMAND_FAILED_INTERRUPTED;
            return this;
        }

        public ResultBuilder setCommandFailed() {
            this.inEnum = ResultEnum.RUNCOMMAND_FAILED;
            return this;
        }

        public ResultBuilder setInstallSuccess() {
            this.inEnum = ResultEnum.INSTALL_SUCCESS;
            return this;
        }

        public ResultBuilder setInsallFailedNoSpace() {
            this.inEnum = ResultEnum.INSTALL_FAILED_NOSPACE;
            return this;
        }

        public ResultBuilder setInstallFailedWrongContainer() {
            this.inEnum = ResultEnum.INSTALL_FAILED_WRONGCONTAINER;
            return this;
        }

        public ResultBuilder setInstallFailedWrongCer() {
            this.inEnum = ResultEnum.INSTALL_FAILED_WRONGCER;
            return this;
        }

        public ResultBuilder setInstallFailed() {
            this.inEnum = ResultEnum.INSTALL_FIALED;
            return this;
        }

        public ResultBuilder setUninstallSuccess() {
            this.inEnum = ResultEnum.UNINSTALL_SUCCESS;
            return this;
        }

        public ResultBuilder setUninstallFailed() {
            this.inEnum = ResultEnum.UNINSTALL_FAILED;
            return this;
        }

        public ResultBuilder setFailed() {
            this.inEnum = ResultEnum.FAILED;
            return this;
        }

        public ResultBuilder setCustomMessage(String customMessage) {
            this.inEnum = ResultEnum.CUSTOM;
            this.inEnum.setCustomMessage(customMessage);
            return this;
        }

        public Result build() {
            if (this.inEnum == null) {
                throw new IllegalStateException("Get a empty or null error message during command execution, can not generate result object");
            }
            Result re = new Result();
            re.message = this.inEnum.getMessage();
            re.statusCode = this.inEnum.getStatusCode();
            return re;
        }
    }

    public static enum ResultEnum {
        RUNCOMMAND_SUCCESS(90, "Command Executed Successfully"),
        RUNCOMMAND_FAILED_TIMEOUT(401, "Run Command Timeout"),
        RUNCOMMAND_FAILED_DENIED(402, "Run Command Permission Denied"),
        RUNCOMMAND_FAILED_INTERRUPTED(403, "Run Command Interrupted"),
        RUNCOMMAND_FAILED(409, "Run Command Failed"),
        INSTALL_SUCCESS(80, "Application installed Successfully"),
        INSTALL_FAILED_NOSPACE(404, "Install Failed because of no enough space"),
        INSTALL_FAILED_WRONGCONTAINER(405, "Install Failed Wrong container"),
        INSTALL_FAILED_WRONGCER(406, "Install Failed Wrong Cer or version"),
        INSTALL_FIALED(407, "Install Failed"),
        UNINSTALL_SUCCESS(70, "Application uninstall Successfully"),
        UNINSTALL_FAILED(408, "Uninstall App Failed"),
        FAILED(409, "Illegal Parameters or State"),
        CUSTOM(0, "");

        private int statusCode;
        private String message;

        private ResultEnum(int sc, String msg) {
            this.statusCode = sc;
            this.message = msg;
        }

        public void setCustomMessage(String customMessage) {
            this.message = customMessage;
        }

        public String getMessage() {
            return this.message;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

